/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.structures.classification;

import java.util.Vector;
import java.util.Map;
import java.util.HashMap;

public class Cluster implements ClusterPart {
    private ClusterPart[] sousClusters;
    private int randomTitreIndex;
    private double similarite = 0.0;
    private Vector<LemmePondere> lemmes = new Vector<LemmePondere>();
    
    public Cluster(ClusterPart[] sousClusters, double similarite){
        this.sousClusters = sousClusters;
        this.similarite = similarite;

        for(int i=0; i<sousClusters.length; i++){
            LemmePondere[] l = sousClusters[i].getAllLemmes();
            for(int j=0; j<l.length; j++){
                lemmes.add(l[j]);
            }
        }
        fusionneLemmes();

        // A changer quand on aura trouvé...
        randomTitreIndex = (int)(Math.random()*sousClusters.length);
    }

    public ClusterPart[] getSousClusters(){
        return sousClusters;
    }

    public int getTotalClusters(){
        int nb = 1;
        for(int i=0; i<sousClusters.length; i++){
            nb += sousClusters[i].getTotalClusters();
        }
        return nb;
    }

    public Map<String, String[]> aplanis(int nbClustersConserves){
        Vector<ClusterPart> clusters = new Vector<ClusterPart>();
        clusters.addElement(this);
        while(clusters.size() < nbClustersConserves && clusters.size() < this.getTotalClusters()){
            // Choix du cluster avec la moindre similarité
            double moindreSimilarite = Double.MAX_VALUE;
            int index = -1;
            for(int i=0; i<clusters.size(); i++){
                if(clusters.elementAt(i).getSimilarite() < moindreSimilarite) {
                    moindreSimilarite = clusters.elementAt(i).getSimilarite();
                    index = i;
                }
            }
            ClusterPart choisi = clusters.get(index);
            // Eclatement
            clusters.removeElement(choisi);
            for(int i=0; i<choisi.getSousClusters().length; i++){
                clusters.addElement(choisi.getSousClusters()[i]);
            }
        }
        Map<String, String[]> res = new HashMap<String, String[]>();
        for(int i=0; i<clusters.size(); i++){
            res.put(clusters.elementAt(i).getTitre(), clusters.elementAt(i).getFeuilles());
        }
        return res;
    }

    public String[] getFeuilles(){
        Vector<String> v = new Vector<String>();
        for(int i=0; i<sousClusters.length; i++){
            String[] s = sousClusters[i].getFeuilles();
            for(int j=0; j<s.length; j++){
                v.addElement(s[j]);
            }
        }
        String[] res = new String[v.size()];
        v.toArray(res);
        return res;
    }

    public String getTitre(){
        return sousClusters[randomTitreIndex].getTitre();
    }

    public double getSimilarite(){
        return similarite;
    }

    public LemmePondere[] getAllLemmes(){
        LemmePondere[] result = new LemmePondere[lemmes.size()];
        lemmes.toArray(result);
        return result;
    }
    
    private void fusionneLemmes(){
        // Fusion de tous les lemmes ayant la même origine, la même nature et la même expression
        for(int i=0; i<lemmes.size(); i++){
            for(int j=i; j<lemmes.size(); j++){
                if(lemmes.elementAt(i).getLemme().equals(lemmes.elementAt(j).getLemme()) &&
                   lemmes.elementAt(i).getCategorie().equals(lemmes.elementAt(j).getCategorie()) &&
                   lemmes.elementAt(i).getOrigine().equals(lemmes.elementAt(j).getOrigine())) {
                    //System.out.println("Fusion : lemme "+lemmes.elementAt(j).getLemme()+" ( "+lemmes.elementAt(i).getNbOccurences()+"/"+lemmes.elementAt(j).getNbOccurences()+"occurences)");
                    lemmes.elementAt(i).addNbOccurences(lemmes.elementAt(j).getNbOccurences());
                    lemmes.removeElementAt(j);
                    j--;
                }
            }
        }
    }

    @Override
    public String toString(){
        String s = "["+getTitre()+" : \n";
        for(int i=0; i<sousClusters.length; i++){
            s+=sousClusters[i].toString()+"\n";
        }
        s+="]";
        return s;
    }

}
